%   Copyright  2020 University of Extremadura (UEx)
%
% loadDeploymentRss
%
%  Input:
%   dataFolder: Path to the folder with the data
%   set: Current deployment information
%
%  Output:
%   data: Structure with the selected data
% -----------------------------------------

function [data] = loadDeploymentRss_old(set, dataFolder)

    %nDefs = getFileNameDefs();
    %fDefs = getFilterDefs();
    
    data = struct;
    data.rss = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_rss.csv'));
    data.coords = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_cdr.csv'));
    data.time = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_tms.csv'));
    data.ids = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_code.csv'));
    %data.zoneId = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_zoneId.csv'));
    %data.idxTrain = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_idxRadioMap.csv'));
    %data.idxTest = csvread(strcat('data\Deployment_',num2str(set.id),'\set',num2str(set.id),'_idxEvaluation.csv'));
    
end

